/**
 * Method: MovieClip.drawRect()
 *   Desc: Draws a rectangle with optional fill.
 * Params: x          Horizontal position of rectangle's top-left corner.
 *         y          Vertical position of rectangle's top-left corner.
 *         w          Width of rectangle, in pixels.
 *         h          Height of rectangle, in pixels.
 *         RGB        Color of rectangle.
 *         alpha      Transparency of rectangle.
 */
MovieClip.prototype.drawRect = function (x, y, w, h, RGB, alpha) {
  this.moveTo(x, y);
  this.beginFill(RGB, alpha);
  this.lineTo(x+w, y);
  this.lineTo(x+w, y+h);
  this.lineTo(x, y+h);
  this.lineTo(x, y);
  this.endFill;
};
